
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Deposit Logs')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php if(!$isMobile): ?>
            <div class="col-xl-12">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title"><?php echo e(__('All Deposit Log')); ?></h3>
                    </div>
                    <div class="site-card-body">
                        <div class="site-table">
                            <div class="table-filter">
                                <div class="filter">
                                    <form action="<?php echo e(route('user.deposit.log')); ?>" method="get">
                                        <div class="search">
                                            <input type="text" id="search" placeholder="Search"
                                                   value="<?php echo e(request('query')); ?>"
                                                   name="query"/>
                                            <input type="date" name="date" value="<?php echo e(request()->get('date')); ?>"/>
                                            <button type="submit" class="apply-btn"><i
                                                    icon-name="search"></i><?php echo e(__('Search')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th><?php echo e(__('Description')); ?></th>
                                        <th><?php echo e(__('Transactions ID')); ?></th>
                                        <th><?php echo e(__('Amount')); ?></th>
                                        <th><?php echo e(__('Fee')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Method')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="table-description">
                                                    <div class="icon">
                                                        <i icon-name="arrow-down-left"></i>
                                                    </div>
                                                    <div class="description">
                                                        <strong><?php echo e($raw->description); ?></strong><?php if(!in_array($raw->approval_cause,['none',""])): ?>
                                                            <span class="optional-msg" data-bs-toggle="tooltip" title=""
                                                                  data-bs-original-title="<?php echo e($raw->approval_cause); ?>"><i
                                                                    icon-name="mail"></i></span>
                                                        <?php endif; ?>
                                                        <div class="date"><?php echo e($raw->created_at); ?></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><strong><?php echo e($raw->tnx); ?></strong></td>
                                            <td><strong
                                                    class="green-color">+<?php echo e($raw->amount.' '.$currency); ?></strong>
                                            </td>
                                            <td><strong class="red-color">-<?php echo e($raw->charge); ?> <?php echo e($currency); ?></strong>
                                            <td>
                                                <?php switch($raw->status->value):
                                                    case ('pending'): ?>
                                                        <div class="site-badge warnning"><?php echo e(__('Pending')); ?></div>
                                                        <?php break; ?>
                                                    <?php case ('success'): ?>
                                                        <div class="site-badge success"><?php echo e(__('Success')); ?></div>
                                                        <?php break; ?>
                                                    <?php case ('failed'): ?>
                                                        <div class="site-badge primary-bg"><?php echo e(__('canceled')); ?></div>
                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                            </td>
                                            <td><strong><?php echo e(ucfirst($raw->method)); ?></strong></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <?php echo e($deposits->links()); ?>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        <?php else: ?>
            <div class="col-12">
                <!-- Transactions -->
                <div class="all-feature-mobile mobile-transactions mb-3">
                    <div class="title"><?php echo e(__('All Deposit Log')); ?></div>
                    <div class="mobile-transaction-filter">
                        <div class="filter">
                            <form action="<?php echo e(route('user.deposit.log')); ?>" method="get">
                                <div class="search">

                                    <input type="text" placeholder="Search" value="<?php echo e(request('query')); ?>"
                                           name="query"/>
                                    <input type="date" name="date" value="<?php echo e(request()->get('date')); ?>"/>
                                    <button type="submit" class="apply-btn"><i icon-name="search"></i></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="contents">
                        <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-transaction">
                                <div class="transaction-left">
                                    <div class="transaction-des">
                                        <div class="transaction-title"><?php echo e($raw->description); ?>

                                        </div>
                                        <div class="transaction-id"><?php echo e($raw->tnx); ?></div>
                                        <div class="transaction-date"><?php echo e($raw->created_at); ?></div>
                                    </div>
                                </div>
                                <div class="transaction-right">
                                    <div
                                        class="transaction-amount add">
                                        + <?php echo e($raw->amount .' '.$currency); ?></div>
                                    <div class="transaction-fee sub">
                                        -<?php echo e($raw->charge.' '. $currency .' '.__('Fee')); ?> </div>
                                    <div class="transaction-gateway"><?php echo e($raw->method); ?></div>


                                    <?php if($raw->status->value == App\Enums\TxnStatus::Pending->value): ?>
                                        <div class="transaction-status pending"><?php echo e(__('Pending')); ?></div>
                                    <?php elseif($raw->status->value ==  App\Enums\TxnStatus::Success->value): ?>
                                        <div class="transaction-status success"><?php echo e(__('Success')); ?></div>
                                    <?php elseif($raw->status->value ==  App\Enums\TxnStatus::Failed->value): ?>
                                        <div class="transaction-status canceled"><?php echo e(__('canceled')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php echo e($deposits->onEachSide(1)->links()); ?>

                </div>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u949790229/domains/crypticafunds.org/public_html/app/Providers/../../resources/views/frontend/default/deposit/log.blade.php ENDPATH**/ ?>