<div class="row">
    <div class="col-xl-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Latest Registered User')); ?></h3>
            </div>
            <div class="site-card-body table-responsive">
                <div class="site-datatable">
                    <table class="data-table mb-0">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Avatar')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Email')); ?></th>
                            <th><?php echo e(__('Balance')); ?></th>
                            <th><?php echo e(__('Profit')); ?></th>
                            <th><?php echo e(__('KYC')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $data['latest_user']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if(null != $user->avatar): ?>
                                        <img class="avatar avatar-round" src="<?php echo e(asset($user->avatar)); ?>" alt=""
                                             height="40" width="40">
                                    <?php else: ?>
                                        <span
                                            class="avatar-text"><?php echo e($user->first_name[0]); ?><?php echo e($user->last_name[0]); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><a href="<?php echo e(route('admin.user.edit',$user->id)); ?>"
                                       class="link"><?php echo e(safe($user->username)); ?></a></td>
                                <td>
                                    <strong><?php echo e(safe($user->email)); ?></strong>
                                </td>
                                <td><strong><?php echo e($currencySymbol . $user->balance); ?></strong></td>
                                <td><strong><?php echo e($currencySymbol . $user->total_profit); ?></strong></td>
                                <td>
                                    <?php if($user->kyc == 1): ?>
                                        <div class="site-badge success"><?php echo e(__('Verified')); ?></div>
                                    <?php else: ?>
                                        <div class="site-badge pending"><?php echo e(__('Unverified')); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($user->status == 1): ?>
                                        <div class="site-badge success"><?php echo e(__('Active')); ?></div>
                                    <?php else: ?>
                                        <div class="site-badge danger"><?php echo e(__('DeActivated')); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td>

                                    <a href="<?php echo e(route('admin.user.edit',$user->id)); ?>"
                                       class="round-icon-btn primary-btn" data-bs-toggle="tooltip" title=""
                                       data-bs-original-title="Edit User"><i icon-name="edit-3"></i></a>
                                    <span type="button"
                                          data-id="<?php echo e($user->id); ?>"
                                          data-name="<?php echo e($user->first_name.' '. $user->last_name); ?>"
                                          class="send-mail"
                                    ><button class="round-icon-btn red-btn" data-bs-toggle="tooltip"
                                             title="" data-bs-original-title="Send Email"><i
                                                icon-name="mail"></i></button></span>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="centered">
                            <td colspan="7">
                                <?php if($data['latest_user']->isEmpty()): ?>
                                    <?php echo e(__('No Data Found')); ?>

                                <?php endif; ?>
                            </td>
                        </tr>

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-xl-12">
        <div class="site-card">
            <div class="site-card-header">
                <h3 class="title"><?php echo e(__('Latest Investment')); ?></h3>
            </div>
            <div class="site-card-body table-responsive">
                <div class="site-datatable">
                    <table class="data-table mb-0">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Avatar')); ?></th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Schema')); ?></th>
                            <th><?php echo e(__('ROI')); ?></th>
                            <th><?php echo e(__('Profit')); ?></th>
                            <th><?php echo e(__('Capital Back')); ?></th>
                            <th><?php echo e(__('Timeline')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $data['latest_invest']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php
                                $calculateInterest = ($invest->interest*$invest->invest_amount)/100;
                                $interest = $invest->interest_type != 'percentage' ? $invest->interest : $calculateInterest;
                            ?>


                            <tr>
                                <td>
                                    <?php if(null != $invest->user->avatar): ?>
                                        <img class="avatar" src="<?php echo e(asset($invest->user->avatar)); ?>" alt=""
                                             height="40" width="40">
                                    <?php else: ?>
                                        <span
                                            class="avatar-text"><?php echo e($invest->user->first_name[0]); ?><?php echo e($invest->user->last_name[0]); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><a href="<?php echo e(route('admin.user.edit',$invest->user_id)); ?>"
                                       class="link"><?php echo e(safe($invest->user->username)); ?></a></td>
                                <td>

                                    <strong> <?php echo e($invest->schema->name); ?> <i
                                            icon-name="arrow-big-right"></i> <?php echo e($currencySymbol.$invest->invest_amount); ?>

                                    </strong>

                                </td>
                                <td>
                                    <strong><?php echo e($invest->interest_type == 'percentage' ? $invest->interest.'%' : $currencySymbol.$invest->interest); ?></strong>
                                </td>

                                <td>
                                    <strong><?php echo e($invest->already_return_profit .' x '.$interest .' = '. ($invest->already_return_profit*$interest).' '. $currency); ?></strong>
                                </td>
                                <td>
                                    <div
                                        class="site-badge <?php echo e($invest->capital_back ? 'success' : 'pending'); ?>"><?php echo e($invest->capital_back ? 'Yes' : 'No'); ?></div>
                                </td>
                                <td>

                                    <?php if($invest->status == App\Enums\InvestStatus::Ongoing): ?>

                                        <div>
                                            <strong><span id="days<?php echo e($invest->id); ?>"></span>D : <span
                                                    id="hours<?php echo e($invest->id); ?>"></span>H : <span
                                                    id="minutes<?php echo e($invest->id); ?>"></span>M : <span
                                                    id="seconds<?php echo e($invest->id); ?>"></span>S</strong>
                                            <span class="site-badge primary-bg ms-2"
                                                  id="percentage<?php echo e($invest->id); ?>"></span>
                                        </div>
                                        <div class="progress investment-timeline">
                                            <div
                                                class="progress-bar progress-bar-striped progress-bar-animated"
                                                id="time-progress<?php echo e($invest->id); ?>" role="progressbar"
                                                aria-valuenow="75" aria-valuemin="0"
                                                aria-valuemax="100"></div>
                                        </div>

                                        <?php $__env->startPush('single-script'); ?>
                                            <script>
                                                (function ($) {
                                                    "use strict";
                                                    // Countdown
                                                    const second = 1000,
                                                        minute = second * 60,
                                                        hour = minute * 60,
                                                        day = hour * 24;
                                                    let timezone = <?php echo json_encode(setting('site_timezone', 'global'), 512) ?>;

                                                    let countDown = new Date('<?php echo e($invest->next_profit_time); ?>').getTime()
                                                    var start = new Date('<?php echo e($invest->last_profit_time ?? $invest->created_at); ?>').getTime()
                                                    setInterval(function () {

                                                        let utc_datetime_str = new Date().toLocaleString("en-US", {timeZone: timezone});
                                                        let now = new Date(utc_datetime_str).getTime();
                                                        let distance = countDown - now;


                                                        var progress = (((now - start) / (countDown - start)) * 100).toFixed(2);


                                                        $("#time-progress<?php echo e($invest->id); ?>").css("width", progress + '%');

                                                        $("#percentage<?php echo e($invest->id); ?>").text(progress >= 100 ? 100 + '%' : progress + '%');

                                                        document.getElementById('days<?php echo e($invest->id); ?>').innerText = Math.floor(distance < 0 ? 0 : distance / (day)),
                                                            document.getElementById('hours<?php echo e($invest->id); ?>').innerText = Math.floor(distance < 0 ? 0 : (distance % (day)) / (hour)),
                                                            document.getElementById('minutes<?php echo e($invest->id); ?>').innerText = Math.floor(distance < 0 ? 0 : (distance % (hour)) / (minute)),
                                                            document.getElementById('seconds<?php echo e($invest->id); ?>').innerText = Math.floor(distance < 0 ? 0 : (distance % (minute)) / second);

                                                    }, second)

                                                })(jQuery)
                                            </script>
                                        <?php $__env->stopPush(); ?>

                                    <?php elseif($invest->status == App\Enums\InvestStatus::Completed): ?>
                                        <div class="site-badge success"><?php echo e(__('Completed')); ?></div>
                                        <div class="progress investment-timeline">
                                            <div
                                                class="progress-bar progress-bar-striped progress-bar-animated"
                                                role="progressbar" aria-valuenow="75" aria-valuemin="0"
                                                aria-valuemax="100" style="width: 100%"></div>
                                        </div>
                                    <?php elseif($invest->status == App\Enums\InvestStatus::Pending): ?>
                                        <div class="site-badge pending"><?php echo e(__('Pending')); ?></div>
                                    <?php else: ?>
                                        <div class="site-badge pending"><?php echo e(__('Canceled')); ?></div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="centered">
                            <td colspan="7">
                                <?php if($data['latest_invest']->isEmpty()): ?>
                                    <?php echo e(__('No Data Found')); ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u958701803/domains/crypticalfund.org/public_html/resources/views/backend/include/__latest_user_invest.blade.php ENDPATH**/ ?>