
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Reset Password')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Login Section -->
    <section class="section-style site-auth">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-5 col-lg-8 col-md-12">
                    <div class="auth-content">
                        <div class="logo">
                            <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset(setting('site_logo','global'))); ?>" alt=""/></a>
                        </div>
                        <div class="title">
                            <h2>👋 <?php echo e(__('Reset password')); ?></h2>
                            <p><?php echo e(__('Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.')); ?></p>
                        </div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <strong><?php echo e($error); ?></strong>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                        <?php if(session('status')): ?>
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                <strong><?php echo e(session('status')); ?></strong>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                            </div>
                        <?php endif; ?>


                        <div class="site-auth-form">


                            <form method="POST" action="<?php echo e(route('password.update')); ?>">
                                <?php echo csrf_field(); ?>

                                <!-- Password Reset Token -->
                                <input type="hidden" name="token" value="<?php echo e($request->route('token')); ?>">

                                <!-- Email Address -->

                                <div class="single-field">
                                    <label class="box-label" for="email"><?php echo e(__('Email')); ?></label>
                                    <input
                                        class="box-input"
                                        type="text"
                                        name="email"
                                        placeholder="Enter your email address"
                                        required
                                        value="<?php echo e(old('email',$request->email)); ?>"
                                    />
                                </div>

                                <div class="single-field">
                                    <label class="box-label" for="email"><?php echo e(__('New Password')); ?></label>
                                    <input
                                        class="box-input"
                                        type="password"
                                        name="password"
                                        required
                                    />
                                </div>

                                <div class="single-field">
                                    <label class="box-label" for="email"><?php echo e(__('Confirm Password')); ?></label>
                                    <input
                                        class="box-input"
                                        type="password"
                                        name="password_confirmation"
                                        required
                                    />
                                </div>

                                <button type="submit" class="site-btn grad-btn w-100">
                                    <?php echo e(__('Reset Password')); ?>

                                </button>
                            </form>

                            <div class="singnup-text">
                                <p>
                                    <?php echo e(__("Don't have an account?")); ?>

                                    <a href="<?php echo e(route('register')); ?>"><?php echo e(__('Signup for free')); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Login Section End -->
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend::layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u724625488/domains/crypticalfund.org/public_html/app/Providers/../../resources/views/frontend/default/auth/reset-password.blade.php ENDPATH**/ ?>