<?php $__env->startSection('title'); ?>
    <?php echo e(__('Manage Referral')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Multi Level Referrals')); ?></h2>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-create')): ?>
                                <button class="title-btn new-referral" type="button"><?php echo e(__('Add New')); ?></button>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">

                <div class="col-xl-4 col-md-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Deposit Bounty')); ?></h3>
                            <div class="col-sm-6">
                                <form action="<?php echo e(route('admin.referral.level-status')); ?>" method="post" id="deposit-status">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="type" value="deposit_level">
                                    <div class="switch-field m-0">
                                        <input
                                            type="radio"
                                            id="deposit-1"
                                            name="status"
                                            <?php if(setting('deposit_level')): echo 'checked'; endif; ?>
                                        />
                                        <label for="deposit-1" class="deposit-status toggle-switch"><?php echo e(__('Active')); ?></label>
                                        <input
                                            type="radio"
                                            id="deposit-0"
                                            name="status"
                                            <?php if(!setting('deposit_level')): echo 'checked'; endif; ?>
                                        />
                                        <label for="deposit-0" class="deposit-status toggle-switch"><?php echo e(__('DeActive')); ?></label>
                                    </div>
                                </form>
                            </div>

                        </div>
                        <div class="site-card-body">
                            <p class="paragraph"><?php echo e(__('You can')); ?>

                                <strong><?php echo e(__('Add').','. __('Edit').' '. __('or').' '. __('Delete')); ?></strong> <?php echo e(__('any of the')); ?>

                                <strong><?php echo e(__('Level Referred User Deposit Bounty')); ?></strong></p>

                            <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single-gateway">
                                    <div class="gateway-name">
                                        <div class="gateway-title">
                                            <h4><?php echo e(__('Level '). $raw->the_order); ?></h4>
                                        </div>
                                    </div>
                                    <div class="gateway-right">
                                        <div class="gateway-status">
                                            <div class="site-badge success"><?php echo e($raw->bounty); ?>%</div>
                                        </div>
                                        <div class="gateway-edit">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-edit')): ?>
                                                <a href="" type="button" class="edit-referral"
                                                   data-id="<?php echo e($raw->id); ?>"
                                                   data-editfor="<?php echo e('Update ' . $raw->type . ' level '. $raw->the_order); ?>"
                                                   data-bounty="<?php echo e($raw->bounty); ?>"
                                                ><i icon-name="edit-3"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-delete')): ?>
                                                <a href="" class="red-bg ms-2 delete-referral" type="button"
                                                   data-id="<?php echo e($raw->id); ?>"
                                                   data-type="<?php echo e($raw->type); ?>"
                                                   data-target="<?php echo e($raw->type . ' level '. $raw->the_order); ?>"
                                                ><i icon-name="trash-2"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Investment Bounty')); ?></h3>
                            <div class="col-sm-6">
                                <form action="<?php echo e(route('admin.referral.level-status')); ?>" method="post" id="investment-status">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="type" value="investment_level">
                                    <div class="switch-field m-0">
                                        <input
                                            type="radio"
                                            id="investment-1"
                                            name="status"
                                            <?php if(setting('investment_level')): echo 'checked'; endif; ?>
                                        />
                                        <label for="investment-1" class="investment-status toggle-switch"><?php echo e(__('Active')); ?></label>
                                        <input
                                            type="radio"
                                            id="investment-0"
                                            name="status"
                                            <?php if(!setting('investment_level')): echo 'checked'; endif; ?>
                                        />
                                        <label for="investment-0" class="investment-status toggle-switch"><?php echo e(__('DeActive')); ?></label>
                                    </div>
                                </form>
                            </div>

                        </div>
                        <div class="site-card-body">
                            <p class="paragraph"><?php echo e(__('You can')); ?>

                                <strong><?php echo e(__('Add').','. __('Edit').' '. __('or').' '. __('Delete')); ?></strong> <?php echo e(__('any of the')); ?>

                                <strong><?php echo e(__('Level Referred User Investment Bounty')); ?></strong></p>

                            <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single-gateway">
                                    <div class="gateway-name">
                                        <div class="gateway-title">
                                            <h4><?php echo e(__('Level '). $raw->the_order); ?></h4>
                                        </div>
                                    </div>
                                    <div class="gateway-right">
                                        <div class="gateway-status">
                                            <div class="site-badge success"><?php echo e($raw->bounty); ?>%</div>
                                        </div>
                                        <div class="gateway-edit">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-edit')): ?>
                                                <a href="" type="button" class="edit-referral"
                                                   data-id="<?php echo e($raw->id); ?>"
                                                   data-editfor="<?php echo e('Update ' . $raw->type . ' level '. $raw->the_order); ?>"
                                                   data-bounty="<?php echo e($raw->bounty); ?>"
                                                ><i icon-name="edit-3"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-delete')): ?>
                                                <a href="" class="red-bg ms-2 delete-referral" type="button"
                                                   data-id="<?php echo e($raw->id); ?>"
                                                   data-type="<?php echo e($raw->type); ?>"
                                                   data-target="<?php echo e($raw->type . ' level '. $raw->the_order); ?>"
                                                ><i icon-name="trash-2"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-12">
                    <div class="site-card">
                        <div class="site-card-header">
                            <h3 class="title"><?php echo e(__('Profit Bounty')); ?></h3>
                            <div class="col-sm-6">
                                <form action="<?php echo e(route('admin.referral.level-status')); ?>" method="post" id="profit-status">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="type" value="profit_level">
                                    <div class="switch-field m-0">
                                        <input
                                            type="radio"
                                            id="profit-1"
                                            name="status"
                                            <?php if(setting('profit_level')): echo 'checked'; endif; ?>
                                        />
                                        <label for="profit-1" class="profit-status toggle-switch"><?php echo e(__('Active')); ?></label>
                                        <input
                                            type="radio"
                                            id="profit-0"
                                            name="status"
                                            <?php if(!setting('profit_level')): echo 'checked'; endif; ?>
                                        />
                                        <label for="profit-0" class="profit-status toggle-switch"><?php echo e(__('DeActive')); ?></label>
                                    </div>
                                </form>
                            </div>

                        </div>
                        <div class="site-card-body">
                            <p class="paragraph"><?php echo e(__('You can')); ?>

                                <strong><?php echo e(__('Add').','. __('Edit').' '. __('or').' '. __('Delete')); ?></strong> <?php echo e(__('any of the')); ?>

                                <strong><?php echo e(__('Level Referred User Profit Bounty')); ?></strong></p>

                            <?php $__currentLoopData = $profits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="single-gateway">
                                    <div class="gateway-name">
                                        <div class="gateway-title">
                                            <h4><?php echo e(__('Level '). $raw->the_order); ?></h4>
                                        </div>
                                    </div>
                                    <div class="gateway-right">
                                        <div class="gateway-status">
                                            <div class="site-badge success"><?php echo e($raw->bounty); ?>%</div>
                                        </div>
                                        <div class="gateway-edit">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-edit')): ?>
                                                <a href="" type="button" class="edit-referral"
                                                   data-id="<?php echo e($raw->id); ?>"
                                                   data-editfor="<?php echo e('Update ' . $raw->type . ' level '. $raw->the_order); ?>"
                                                   data-bounty="<?php echo e($raw->bounty); ?>"
                                                ><i icon-name="edit-3"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-delete')): ?>
                                                <a href="" class="red-bg ms-2 delete-referral" type="button"
                                                   data-id="<?php echo e($raw->id); ?>"
                                                   data-type="<?php echo e($raw->type); ?>"
                                                   data-target="<?php echo e($raw->type . ' level '. $raw->the_order); ?>"
                                                ><i icon-name="trash-2"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- Modal for Add New Level -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-create')): ?>
            <?php echo $__env->make('backend.referral.include.__new_level_referral', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Add New Level-->

        <!-- Modal for Edit Level -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-edit')): ?>
            <?php echo $__env->make('backend.referral.include.__edit_level_referral', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Edit Level-->


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('referral-delete')): ?>
            <?php echo $__env->make('backend.referral.include.__delete_level_referral', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Delete Level End-->

        <?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        $('.new-referral').on('click',function (e) {
            "use strict";
            e.preventDefault();
            var type = $(this).data('type');
            $('.referral-type').val(type);
            $('#addNewReferral').modal('show');

        })

        $('.edit-referral').on('click',function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');
            var editFor = $(this).data('editfor');
            var bounty = $(this).data('bounty');

            var url = '<?php echo e(route("admin.referral.level.update",":id")); ?>';
            url = url.replace(':id', id);

            var form = document.getElementById("level-form");
            form.setAttribute("action", url);



            $('.referral-id').val(id);
            $('.edit-for').html(editFor);
            $('.bounty').val(bounty);

            $('#editReferral').modal('show');

        })
        $('.delete-referral').on('click',function (e) {
            "use strict";
            e.preventDefault();
            var id = $(this).data('id');
            var target = $(this).data('target');
            var type = $(this).data('type');

            var url = '<?php echo e(route("admin.referral.level.destroy",":id")); ?>';
            url = url.replace(':id', id);

            var form = document.getElementById("level-delete");
            form.setAttribute("action", url);

            $('.target').html(target);
            $('.level-type').val(type);
            $('#deleteReferral').modal('show');

        })



        $(".toggle-switch").click(function (message) {
            let className = $(this).attr('class');
            var idNames = className.split(' ')[0]; // Split the class names into an array
            $("#"+idNames).submit();
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u949790229/domains/crypticafunds.org/public_html/resources/views/backend/referral/level/index.blade.php ENDPATH**/ ?>