
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Support Tickets')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Support Tickets')); ?></h3>
                    <div class="card-header-links">
                        <a href="<?php echo e(route('user.ticket.new')); ?>" class="card-header-link"><?php echo e(__('Create Ticket')); ?></a>
                    </div>
                </div>
                <div class="site-card-body">
                    <div class="site-transactions">
                        <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single">
                                <div class="left">
                                    <div class="icon">
                                        <i icon-name="flag"></i>
                                    </div>
                                    <div class="content">
                                        <div class="title"><?php echo e($ticket->title); ?></div>
                                        <div class="date"><?php echo e(__('Created ').$ticket->created_at); ?>

                                            <?php if($ticket->isOpen()): ?>
                                                <span
                                                    class="ms-2 status site-badge badge-pending"><?php echo e(__('Opened')); ?></span>
                                            <?php elseif($ticket->isClosed()): ?>
                                                <span
                                                    class="ms-2 status site-badge badge-success"><?php echo e(__('Completed')); ?></span>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="right">
                                    <div class="action">

                                        <?php if($ticket->isOpen()): ?>
                                            <a href="<?php echo e(route('user.ticket.close.now',$ticket->uuid)); ?>" class="cancel"
                                               data-bs-toggle="tooltip" title="Complete Ticket"
                                               data-bs-original-title="Complete Ticket"><i icon-name="check"></i></a>
                                            <a href="<?php echo e(route('user.ticket.show',$ticket->uuid)); ?>"
                                               data-bs-toggle="tooltip" title="Show Ticket"
                                               data-bs-original-title="Show Ticket"><i icon-name="eye"></i></a>
                                        <?php elseif($ticket->isClosed()): ?>
                                            <a href="#" class="cancel disabled"><i icon-name="check"></i></a>
                                            <a href="<?php echo e(route('user.ticket.show',$ticket->uuid)); ?>"
                                               data-bs-toggle="tooltip" data-bs-placement="top"
                                               title="Re-open the Ticket"><i icon-name="book-open"></i></a>
                                        <?php endif; ?>


                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($tickets->isEmpty()): ?>
                            <p class="centered"><?php echo e(__('No Data Found')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u949790229/domains/crypticafunds.org/public_html/app/Providers/../../resources/views/frontend/default/ticket/index.blade.php ENDPATH**/ ?>