<?php
    $schemas = \App\Models\Schema::where('status',1)->with('schedule')->get(['id','name','type','min_amount','max_amount','fixed_amount']);
?>

<section class="section-style light-blue-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7 col-lg-12">
                <div class="section-title text-center">
                    <h4 data-aos="fade-down" data-aos-duration="2000"><?php echo e($data['calculation_title_small']); ?></h4>
                    <h2 data-aos="fade-down" data-aos-duration="1500">
                        <?php echo e($data['calculation_title_big']); ?>

                    </h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-6 col-md-12">
                <div class="earnings-calculator-img" data-aos="fade-right" data-aos-duration="2000">
                    <img class="rounded" src="<?php echo e(asset($data['calculation_left_img'])); ?>" alt="">
                    <a href="<?php echo e($data['intro_video']); ?>" class="video video-popup"><i class="fas fa-play"></i></a>
                </div>
            </div>
            <div class="col-xl-6 col-md-12">
                <div class="earnings-calculator" data-aos="fade-left" data-aos-duration="2000">
                    <form action="#">
                        <div class="single-box">
                            <label for=""><?php echo e(__('Investment Plans:')); ?></label>
                            <select name="selectCalculationPlan" id="selectPlan"
                                    class="site-nice-select plan-selects mb-2">
                                <option value="0"><?php echo e(__('---Select Plan---')); ?></option>
                                <?php $__currentLoopData = $schemas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schema): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($schema->id); ?>"><?php echo e($schema->name); ?>

                                        (<?php echo e($schema->type == 'range' ? $currencySymbol . $schema->min_amount . '-' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount); ?>

                                        )
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                        <div class="single-box">
                            <label for=""><?php echo e(__('Enter Amount:')); ?> </label>
                            <div class="input-group">
                                <input type="text" id="enter-amount" class="form-control" aria-label="Amount"
                                       aria-describedby="basic-addon1">
                                <span class="input-group-text" id="basic-addon1"><?php echo e($currency); ?></span>
                            </div>
                        </div>

                        <div class="single-box">
                            <div class="input-info-text charge " id="amount-level"></div>
                        </div>

                        <div class="single-box">
                            <label for=""><?php echo e(__('Profit:')); ?> <span id="profit-label"></span></label>
                            <div class="input-group mb-0">
                                <input type="text" class="form-control" id="profit" disabled>
                                <span class="input-group-text" id="basic-addon1"><?php echo e($currency); ?></span>
                            </div>
                        </div>
                        <div class="single-box mb-0">
                            <a href="<?php echo e(route('register')); ?>" class="site-btn primary-btn w-100 centered"><i
                                    class="anticon anticon-bank"></i><?php echo e(__("Let's Start Earning")); ?></a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->startPush('script'); ?>
    <script>
        $('#selectPlan').on('change',function (e) {
            e.preventDefault();
            "use strict"

            var id = $(this).val();

            if (id != 0) {

                var invest_amount = $("#enter-amount");
                invest_amount.val('');
                invest_amount.attr('readonly', false);

                var url = '<?php echo e(route("user.schema.select", ":id")); ?>';
                url = url.replace(':id', id);

                $.ajax({
                    url: url, success: function (result) {
                        $('#amount-level').html('Capital Back:' + result.capital_back);
                        $('#profit-label').html(result.return_interest + ' - ' + result.number_period);

                        if (result.invest_amount > 0) {
                            invest_amount.val(result.invest_amount);
                            invest_amount.attr('readonly', true);
                        }

                        if (result.number_period === 'Unlimited Times') {
                            $('#profit').val('Unlimited');
                        } else {

                            if (result.interest_type === 'percentage') {
                                $('#profit').val(calPercentage(result.invest_amount, result.interest) * result.period);

                            } else {
                                $('#profit').val(result.interest * result.period);
                            }
                        }

                    }
                });
            }

        })

        $('#enter-amount').on('keyup',function (e) {
            e.preventDefault();
            "use strict"
            var id = $('#selectPlan').val();

            if (id != 0) {
                var url = '<?php echo e(route("user.schema.select", ":id")); ?>';
                url = url.replace(':id', id);

                $.ajax({
                    url: url, success: function (result) {

                        if (result.number_period === 'Unlimited Times') {
                            $('#profit').val('Unlimited');
                        } else {

                            if (result.interest_type === 'percentage') {
                                var invest_amount = $("#enter-amount").val();
                                $('#profit').val(calPercentage(invest_amount, result.interest) * result.period);

                            } else {
                                $('#profit').val(result.interest * result.period);
                            }
                        }

                    }
                });
            }

        })


    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u949790229/domains/crypticafunds.org/public_html/app/Providers/../../resources/views/frontend/default/home/include/__calculation.blade.php ENDPATH**/ ?>